# -*- coding: utf-8 -*-
import smtplib
from email.MIMEText import MIMEText
from email.MIMEImage import MIMEImage
from email.MIMEMultipart import MIMEMultipart
from email.Header import Header
from email.Utils import formatdate
import sys

title = sys.argv[1]
body = sys.argv[2]
to_addr = sys.argv[3]
from_addr = sys.argv[4]
from_addr_pw = sys.argv[5]
attachment = []
for cnt in range(0,len(sys.argv)):
	if cnt < 6:
		continue
	attachment.append(sys.argv[cnt])

def create_message(from_addr, to_addr, subject, body, encoding, attachment):
	msg = MIMEMultipart()
	msg['Subject'] = Header(subject, encoding)
	msg['From'] = from_addr
	msg['To'] = to_addr
	msg['Date'] = formatdate()

	related = MIMEMultipart('related')
	alt = MIMEMultipart('alternative')
	related.attach(alt)

	content = MIMEText(body, 'plain', encoding)
	alt.attach(content)

	for filename in attachment:
		fp = file('%s' % filename, 'rb')
		img = MIMEImage(fp.read(), 'png', name=filename)
		related.attach(img)

	msg.attach(related)
	return msg
	pass

def send_via_gmail(from_addr, to_addr, msg):
	s = smtplib.SMTP('smtp.gmail.com', 587)
	s.ehlo()
	s.starttls()
	s.ehlo()
	s.login(from_addr, 'je1ocv/1')
	s.sendmail(from_addr, [to_addr], msg.as_string())
	s.close()

msg = create_message(from_addr, to_addr, title, body, 'utf-8', attachment)
send_via_gmail(from_addr, to_addr, msg)
